/*
  DS3231lib.h - Library for using the DS3231 RTC module
  Created by Jonas Zender
*/

#ifndef DS3231lib_h
#define DS3231lib_h

//Structure for Time Reading Results
struct Time {
  byte Seconds;
  byte Minutes;
  byte Hours;
  byte Day;
  byte Date;
  byte Month;
  byte Year;
};

//Definitions for alarm masks
#define A1_EVERY_SECOND 0
#define A1_MATCH_SECONDS 1
#define A1_MATCH_MINUTES 2
#define A1_MATCH_HOURS 3
#define A1_MATCH_DATE 4
#define A1_MATCH_DAY 5

#define A2_EVERY_MINUTE 0
#define A2_MATCH_MINUTES 1
#define A2_MATCH_HOURS 2
#define A2_MATCH_DATE 3
#define A2_MATCH_DAY 4

class DS3231
{
  private:
    byte _I2Caddress = 0x68;
    byte _Alarm1Mask[6]={B01111000,
                         B01110000,
                         B01100000,
                         B01000000,
                         B00000000,
                         B10000000};
    byte _Alarm2Mask[5]={B01110000,
                         B01100000,
                         B01000000,
                         B00000000,
                         B10000000};

  public:
    //Constructor
    DS3231(bool I2Cinit, byte I2Caddress);
    
    //Time Registers
    bool setTime(byte Sec, byte Min, byte Hour, byte Day, byte Date, byte Month, byte Year);
    bool getTime(Time* t);
    bool displayTimeSerial();

    //Alarms
    bool setAlarm1(byte Sec, byte Min, byte Hour, byte DayDate, byte Setting); //Set Alarm 1 Time and Rate
    bool setAlarm2(byte Min, byte Hour, byte DayDate, byte Setting);           //Set Alarm 2 Time and Rate
    bool resetAlarm1();    //Reset Alarm1 Flag
    bool resetAlarm2();    //Reset Alarm2 Flag

    //Status Register
    byte getStatus();     //get complete Status Register
    bool displayStatusSerial(); //*display the status register in serial monitor
    bool getOSF();        //check Oscillator Stop Flag (OSF)
    bool resetOSF();      //reset Oscillator Stop Flag (OSF)
    bool getEN32kHz();    //check if SQW signal output is activated (EN32kHz)
    bool setEN32kHz(bool active);    //(de)activate SQW signal output (EN32kHz)
    bool getBSY();        //check if RTC is busy (BSY)
    bool getA1F();        //check alarm 1 flag (A1F)
    bool getA2F();        //check alarm 2 flag (A2F)

    //Control Register
    byte getControl();
    bool displayControlSerial();
    bool setControl(byte Setting);
    bool getEOSC();
    bool setEOSC(bool active);
    bool getBBSQW();
    bool setBBSQW(bool active);
    byte getSQWOF();
    bool setSQWOF(byte f);
    bool getINTCN();
    bool setINTCN(bool active);
    bool getA2IE();
    bool setA2IE(bool active);
    bool getA1IE();
    bool setA1IE(bool active);
    
    //Conversions
    byte DECtoBCD(byte val);  //Convert decimal to binary coded decimal
    byte BCDtoDEC(byte val);  //Convert binary coded decimal to decimal

};

#endif
